<?php

error_reporting(0);
ini_set('display_errors',0);

if(!file_exists('../config.php'))
{
    header('Location: '.siteURL().'/index.php');
    die();
}

ini_set('max_execution_time', 1800);

session_name('far');
session_start();

require_once('../config.php');

define('APP_NAME', 'Facebook Auto Commenter');
define("APP_VERSION", "3.0.3");

define('PRODUCTID', '13097099');

define('DEMO_VERSION',false);
define('DEMO_ERROR',"Sorry, you can not perform this action on demo version.");

define('BASE_PATH',siteURL());

define('COPYRIGHT', 'Copyright © 2015 HENOZ Developers Pvt Ltd. All Rights Reserved.');

define('LOAD_POSTS', 20);
define('LOAD_GROUPS', 20);
define('LOAD_SCHEDULE_POSTS', 10);

require_once('classes/user.php');


function siteURL()
{
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $domainName = $_SERVER['HTTP_HOST'];
    $siteName = trim($_SERVER['PHP_SELF'],"/");
    $siteName = explode("/",$siteName);
    if(empty($siteName))
        return $protocol.$domainName.'/';
    else{
        $protocol = $protocol.$domainName;
        for($i = 0; $i < count($siteName) - 2; $i++){
            $protocol = $protocol.'/'.$siteName[$i];
        }
        return $protocol;
    }
}

function assetsPath()
{
    return siteURL() . '/app/assets/';
}

function baseUrl($url)
{
    return siteURL() . '/app/' . $url;
}

function check_user()
{
    $user = new User();

    if(!$user->get_user()){
        header('Location: login.php');
    }
}

function check_admin()
{
    $user = new User();

    return $user->is_admin();
}

function get_cron_info()
{
    $user = new User();

    return $user->get_cron_info();
}

function to_my_timezone($timestamp)
{
    $user = new User();
    $user_settings = $user->get_user();
    return $user->convert_to_timezone($timestamp, 'Europe/London', $user_settings['timezone']);
}

function strlenchar($text, $limit)
{
    return (strlen($text) > $limit && $limit > 0)? substr($text, 0, $limit)."..." : $text;
}

function check_activation($redirect = false)
{
    $user_class = new User();
    $res = $user_class->check_activation();
    if(!$res && $redirect){
        header('Location: '.baseUrl('activation.php'));
        die();
    }else{
        return $res;
    }
}